local key = ModPath .. '	' .. RequiredScript
if _G[key] then return else _G[key] = true end

function BlackMarketManager:damage_multiplier(name, categories, silencer, detection_risk, current_state, blueprint)
	local multiplier = 1

	if tweak_data.weapon[name] and tweak_data.weapon[name].ignore_damage_upgrades then
		return multiplier
	end

	local managers_player = managers.player
	for _, category in ipairs(categories) do
		multiplier = multiplier + 1 - managers_player:upgrade_value(category, "damage_multiplier", 1)
	end

	multiplier = multiplier + 1 - managers_player:upgrade_value(name, "damage_multiplier", 1)
	multiplier = multiplier + 1 - managers_player:upgrade_value("player", "passive_damage_multiplier", 1)
	multiplier = multiplier + 1 - managers_player:upgrade_value("weapon", "passive_damage_multiplier", 1)

	if silencer then
		multiplier = multiplier + 1 - managers_player:upgrade_value("weapon", "silencer_damage_multiplier", 1)
	end

	local detection_risk_damage_multiplier = managers_player:upgrade_value("player", "detection_risk_damage_multiplier")
	multiplier = multiplier - managers_player:get_value_from_risk_upgrade(detection_risk_damage_multiplier, detection_risk or NoMA.cached_detection_risk)

	if managers_player:has_category_upgrade("player", "overkill_health_to_damage_multiplier") then
		local damage_ratio = managers_player:upgrade_value("player", "overkill_health_to_damage_multiplier", 1) - 1
		multiplier = multiplier + damage_ratio
	end

	if current_state and not current_state:in_steelsight() then
		for _, category in ipairs(categories) do
			multiplier = multiplier + 1 - managers_player:upgrade_value(category, "hip_fire_damage_multiplier", 1)
		end
	end

	if blueprint and self:is_weapon_modified(managers.weapon_factory:get_factory_id_by_weapon_id(name), blueprint) then
		multiplier = multiplier + 1 - managers_player:upgrade_value("weapon", "modded_damage_multiplier", 1)
	end

	-- multiplier = multiplier + 1 - managers_player:get_property("trigger_happy", 1) -- NO! it's not the right place to do it

	return self:_convert_add_to_mul(multiplier)
end
